/***************************************************************/
//
//
//		DirectX	[shadow.cpp]
//
//										Author	kazuki tanaka
//										Date	2016 11/09
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25

/*---------------------------------------------------------------
		wb_[t@C
---------------------------------------------------------------*/
#include "main.h"
#include "shadow.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define NUM_POLYGON   (2)		

#define NUM_VERTEX    (4)
#define NUM_INDEX     (6)

#define SHADOW_NUMBER (1)

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define TEXTURE_NAME ("data\\TEXTURE\\shadow000.jpg")

// tB[hTCY̍\
typedef struct{

	D3DXVECTOR3 center;
	D3DXVECTOR3 angle;
	D3DXVECTOR2 radius;
	D3DXCOLOR   color;
	D3DXVECTOR3 scale;
	bool        exist;

}SHADOW;

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

HRESULT MakeVertexShadow(LPDIRECT3DDEVICE9 pDevice);	// _̍쐬

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureShadow        = nullptr;	// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferShadow = nullptr;	// _obt@C^[tF[Xւ̃|C^
LPDIRECT3DINDEXBUFFER9 g_pIdxBufferShadow  = nullptr;	// CfbNXobt@C^[tF[Xւ̃|C^

SHADOW shadowes;


// |S̏
void InitShadow( void )
{


	// foCX󂯎p֐
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// _obt@CfbNX̍쐬
	MakeVertexShadow( pDevice );

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME, &g_pTextureShadow )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "ShadoweNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}

	
}

// |S̏
void UninitShadow( void )
{


	SAFE_RELEASE( g_pTextureShadow )

	SAFE_RELEASE( g_pVtxBufferShadow )

	SAFE_RELEASE( g_pIdxBufferShadow )


}

// |S̍XV
void UpdateShadow( void )
{

	// e̍XV

}

// |S̕`
void DrawShadow( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	D3DXMATRIX mtxDefault;

	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &mtxDefault );

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &mtxDefault );

	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferShadow,								// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_3D ));							// ̃XgChl(oCgP)

	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_3D );

	// CfbNXobt@̐ݒ
	pDevice ->SetIndices( g_pIdxBufferShadow );

	// eNX`̐ݒ
	pDevice->SetTexture( 0, g_pTextureShadow );

	// Z̐ݒ
	pDevice ->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_REVSUBTRACT );
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
	pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	pDevice ->SetRenderState( D3DRS_LIGHTING, false );
	
	// |S̕`
	pDevice ->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 0, NUM_INDEX * SHADOW_NUMBER, 0, NUM_POLYGON * SHADOW_NUMBER );

	pDevice ->SetRenderState( D3DRS_LIGHTING, true );

	pDevice->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_ADD );		
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );


}

// _̍쐬
HRESULT MakeVertexShadow( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_3D *pVtx;											// zAhX
	WORD      *pIndex;											// zAhXCfbNX

	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
			sizeof( VERTEX_3D ) * NUM_VERTEX * SHADOW_NUMBER,	// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,									// gp@
			FVF_VERTEX_3D,										// gp钸_tH[}bg
			D3DPOOL_MANAGED,									// obt@̊Ǘ@
			&g_pVtxBufferShadow,								// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " Shadow VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG
		return E_FAIL;
	}


	// zAhX̎擾
	g_pVtxBufferShadow -> Lock( 0, 0, (void**)&pVtx, 0 );


	// _obt@̐ݒ
	for( int index = 0; index < SHADOW_NUMBER; index++ ){

	
		pVtx[ 0 + NUM_VERTEX*index ].pos    = D3DXVECTOR3( -15.0, 0.0000001f,  15.0 );
		pVtx[ 1 + NUM_VERTEX*index ].pos    = D3DXVECTOR3(  15.0, 0.0000001f,  15.0 );
		pVtx[ 2 + NUM_VERTEX*index ].pos    = D3DXVECTOR3( -15.0, 0.0000001f, -15.0 );
		pVtx[ 3 + NUM_VERTEX*index ].pos    = D3DXVECTOR3(  15.0, 0.0000001f, -15.0 );

		pVtx[ 0 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ 1 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ 2 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		pVtx[ 3 + NUM_VERTEX*index ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );

		pVtx[ 0 + NUM_VERTEX*index ].color  = D3DCOLOR_RGBA( 192, 192, 155, 255 );
		pVtx[ 1 + NUM_VERTEX*index ].color  = D3DCOLOR_RGBA( 192, 192, 155, 255 );
		pVtx[ 2 + NUM_VERTEX*index ].color  = D3DCOLOR_RGBA( 192, 192, 155, 255 );
		pVtx[ 3 + NUM_VERTEX*index ].color  = D3DCOLOR_RGBA( 192, 192, 155, 255 );

		pVtx[ 0 + NUM_VERTEX*index ].tex    = D3DXVECTOR2( 0.0f, 0.0f );
		pVtx[ 1 + NUM_VERTEX*index ].tex    = D3DXVECTOR2( 1.0f, 0.0f );
		pVtx[ 2 + NUM_VERTEX*index ].tex    = D3DXVECTOR2( 0.0f, 1.0f );
		pVtx[ 3 + NUM_VERTEX*index ].tex    = D3DXVECTOR2( 1.0f, 1.0f );
	
	}


	// obt@̃AbN
	g_pVtxBufferShadow ->Unlock( );


	// CfbNXobt@̒`
	if( FAILED( pDevice ->CreateIndexBuffer(
		sizeof( WORD ) * NUM_INDEX * SHADOW_NUMBER,
		D3DUSAGE_WRITEONLY,
		D3DFMT_INDEX16,
		D3DPOOL_MANAGED,
		&g_pIdxBufferShadow,
		NULL)))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "Index Buffer ERROR !!", MB_OK | MB_ICONWARNING );
		#endif	// -> _DEBUG
		return E_FAIL;
	}


	// CfbNXbNzAhX擾
	g_pIdxBufferShadow->Lock( 0, 0, (void**)&pIndex, 0 );


	// _W̐ݒ
	for( int index = 0; index < SHADOW_NUMBER; index++ ){
	
		pIndex[ 0 + ( NUM_INDEX * index ) ] = 0 + ( NUM_VERTEX * index );
		pIndex[ 1 + ( NUM_INDEX * index ) ] = 1 + ( NUM_VERTEX * index );
		pIndex[ 2 + ( NUM_INDEX * index ) ] = 2 + ( NUM_VERTEX * index );
		pIndex[ 3 + ( NUM_INDEX * index ) ] = 2 + ( NUM_VERTEX * index );
		pIndex[ 4 + ( NUM_INDEX * index ) ] = 1 + ( NUM_VERTEX * index );
		pIndex[ 5 + ( NUM_INDEX * index ) ] = 3 + ( NUM_VERTEX * index );
	
	}

	// obt@̃AbN
	g_pIdxBufferShadow ->Unlock( );

	return S_OK;

}



